# Procédure de mise en route de l'application AWConsulting (Flask)

## 🔧 Prérequis

- Python 3.10+ installé
- pip installé
- Accès à Internet pour installer les dépendances
- Certificats `cert.pem` et `key.pem` présents à la racine du projet

## 📦 Installation

1. Ouvrir un terminal dans le dossier du projet
2. Installer les dépendances :

```bash
pip install -r requirements.txt
```

3. Créer un fichier `.env` et y ajouter :

```
SECRET_KEY=un_secret_au_hasard
```

4. Vérifier la connexion à MySQL dans `app.py`

## 🚀 Lancement (HTTPS avec Flask)

```bash
python app.py
```

Cela démarre le serveur sécurisé sur :
```
https://127.0.0.1:8443
ou
https://192.168.x.x:8443
```

## ✅ Optionnel : Lancement via script Windows

Double-cliquer sur `app.py` (à créer si besoin) pour lancer automatiquement l'app.

## 🔐 Certificat

Le certificat utilisé est auto-signé. Une alerte de sécurité peut apparaître la première fois, c’est normal.

## 📁 Fichiers importants

- `app.py` : fichier principal de l’application Flask
- `cert.pem` / `key.pem` : certificats SSL
- `requirements.txt` : dépendances Python
- `templates/` : pages HTML
- `static/` : fichiers CSS / images
- `.env` : configuration secrète