from datetime import datetime
import os
import subprocess
import qrcode
from flask import Flask, render_template, request, redirect, url_for, session, flash
from flask_mail import Mail, Message
import mysql.connector
from dotenv import load_dotenv

load_dotenv()
app = Flask(__name__)
app.secret_key = os.environ.get("SECRET_KEY")

app.config["MAIL_SERVER"] = os.environ.get("MAIL_SERVER")
app.config["MAIL_PORT"] = int(os.environ.get("MAIL_PORT"))
app.config["MAIL_USERNAME"] = os.environ.get("MAIL_USERNAME")
app.config["MAIL_PASSWORD"] = os.environ.get("MAIL_PASSWORD")
app.config["MAIL_USE_TLS"] = True
app.config["MAIL_USE_SSL"] = False
app.config["MAIL_DEFAULT_SENDER"] = os.environ.get("MAIL_USERNAME")
mail = Mail(app)

def get_db_connection():
    return mysql.connector.connect(
        host=os.environ.get("DB_HOST"),
        user=os.environ.get("DB_USER"),
        password=os.environ.get("DB_PASSWORD"),
        database=os.environ.get("DB_NAME")
    )

@app.route("/")
def dashboard():
    if 'admin' not in session:
        return redirect(url_for("login"))
    recherche = request.args.get("recherche", "")
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    if recherche:
        filtre = f"%{recherche}%"
        cursor.execute("SELECT * FROM users WHERE nom LIKE %s OR prenom LIKE %s OR email LIKE %s", (filtre, filtre, filtre))
    else:
        cursor.execute("SELECT * FROM users")
    users = cursor.fetchall()
    conn.close()
    return render_template("dashboard.html", users=users)

@app.route("/delete_user/<email>", methods=["POST"])
def delete_user(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("DELETE FROM cagnotte_logs WHERE user_email = %s", (email,))
    cursor.execute("DELETE FROM users WHERE email = %s", (email,))
    conn.commit()
    conn.close()
    flash("Utilisateur supprimé.")
    return redirect(url_for("dashboard"))

@app.route("/login", methods=["GET", "POST"])
def login():
    if request.method == "POST":
        email = request.form["email"]
        password = request.form["password"]
        conn = get_db_connection()
        cursor = conn.cursor(dictionary=True)
        cursor.execute("SELECT * FROM admins WHERE email = %s AND mot_de_passe = %s", (email, password))
        admin = cursor.fetchone()
        conn.close()
        if admin:
            session["admin"] = True
            return redirect(url_for("dashboard"))
        flash("Identifiants invalides.")
    return render_template("login.html")

@app.route("/profile/<email>")
def voir_utilisateur(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    conn.close()
    if user:
        return render_template("profile.html", user=user)
    else:
        return "Utilisateur introuvable."

    email = request.form.get("email")
    ajout = request.form.get("ajout")
    retrait = request.form.get("retrait")
    remplacement = request.form.get("remplacement")
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if ajout:
        cagnotte += int(ajout)
    if retrait:
        cagnotte -= int(retrait)
    if remplacement:
        cagnotte = int(remplacement)
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/modifier_cagnotte", methods=["POST"])
def modifier_cagnotte():
    if 'admin' not in session:
        return redirect(url_for("login"))
    email = request.form.get("email")
    montant = request.form.get("montant")
    action = request.form.get("action")
    if not montant or not action:
        flash("Champ manquant.")
        return redirect(url_for("voir_utilisateur", email=email))
    montant = int(montant)
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if action == "ajouter":
        cagnotte += montant
    elif action == "retirer":
        cagnotte -= montant
    elif action == "remplacer":
        cagnotte = montant
    else:
        flash("Action invalide.")
        return redirect(url_for("voir_utilisateur", email=email))
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

    email = request.form.get("email")
    montant = request.form.get("montant")
    action = request.form.get("action")
    if not email or not montant or not action:
        flash("Champs manquants.")
        return redirect(url_for("dashboard"))
    try:
        montant = int(montant)
    except ValueError:
        flash("Montant invalide.")
        return redirect(url_for("dashboard"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if action == "ajouter":
        cagnotte += montant
    elif action == "retirer":
        cagnotte -= montant
    elif action == "remplacer":
        cagnotte = montant
    else:
        conn.close()
        flash("Action invalide.")
        return redirect(url_for("dashboard"))
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/create_user", methods=["GET", "POST"])
def create_user():
    if 'admin' not in session:
        return redirect(url_for("login"))
    if request.method == "POST":
        nom = request.form["nom"]
        prenom = request.form["prenom"]
        email = request.form["email"]
        telephone = request.form["telephone"]
        adresse = request.form["adresse"]
        token = os.urandom(16).hex()
        conn = get_db_connection()
        cursor = conn.cursor()
        cursor.execute("INSERT INTO users (nom, prenom, email, tel, adrs, token, cagnotte) VALUES (%s, %s, %s, %s, %s, %s, %s)", (nom, prenom, email, telephone, adresse, token, 0))
        conn.commit()
        conn.close()
        # Générer le QR Code
        qr = qrcode.make(token)
        qr_path = os.path.join("qr_temp", f"{email.replace('@', '_')}.png")
        qr.save(qr_path)
        msg = Message("Bienvenue dans notre programme de fidélité", recipients=[email])
        msg.body = f"Bonjour {prenom},\n\nVoici votre QR code en pièce jointe.\n\nCordialement."
        with open(qr_path, 'rb') as fp:
            msg.attach("qrcode.png", "image/png", fp.read())
        mail.send(msg)
        flash("Utilisateur créé et e-mail envoyé !")
        return redirect(url_for("dashboard"))
    return render_template("create_user.html")

@app.route("/scanner")
def scanner():
    if 'admin' not in session:
        return redirect(url_for("login"))
    return render_template("scanner.html")

@app.route("/renvoyer_qr/<email>", methods=["POST"])
def renvoyer_qr(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT prenom, token FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    conn.close()
    if not user:
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    qr = qrcode.make(token)
    qr_path = os.path.join("qr_temp", f"{email.replace('@', '_')}.png")
    qr.save(qr_path)
    msg = Message("Rappel : votre QR Code", recipients=[email])
    msg.body = f"Bonjour {user['prenom']},\n\nVoici à nouveau votre QR code en pièce jointe.\n\nCordialement."
    with open(qr_path, 'rb') as fp:
        msg.attach("qrcode.png", "image/png", fp.read())
    mail.send(msg)
    flash("QR code renvoyé à l’utilisateur.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/historique")
def historique():
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("""SELECT c.*, u.nom, u.prenom FROM cagnotte_logs c JOIN users u ON u.email = c.user_email ORDER BY c.date_ajout DESC""")
    logs = cursor.fetchall()
    for log in logs:
        if isinstance(log['date_ajout'], datetime):
            log['date_ajout'] = log['date_ajout'].strftime('%d/%m/%Y %H:%M:%S')
    for log in logs:
        if isinstance(log['date_ajout'], datetime):
            log['date_ajout'] = log['date_ajout'].strftime('%d/%m/%Y %H:%M:%S')
    conn.close()
    return render_template("historique.html", logs=logs)

@app.route("/envoyer-email-masse", methods=["GET", "POST"])
def envoyer_email_masse():
    if "admin" not in session:
        return redirect("/login")

    if request.method == "POST":
        sujet = request.form["sujet"]
        message = request.form["message"]

        conn = get_db_connection()
        cursor = conn.cursor(dictionary=True)
        cursor.execute("SELECT email, prenom FROM users")
        users = cursor.fetchall()
        conn.close()

        for user in users:
            msg = Message(sujet, recipients=[user["email"]])
            msg.body = f"Bonjour {user['prenom']},\n\n{message}\n\nCordialement."
            mail.send(msg)

        flash("E-mails envoyés avec succès à tous les utilisateurs.")
        return "✅ E-mails envoyés à tous les utilisateurs avec succès !"

    return render_template("email_masse.html")

from datetime import datetime
import os
import subprocess
from flask import Flask, render_template, request, redirect, url_for, session, flash
from flask_mail import Mail, Message
import mysql.connector
from dotenv import load_dotenv

load_dotenv()
app = Flask(__name__)
app.secret_key = os.environ.get("SECRET_KEY")

app.config["MAIL_SERVER"] = os.environ.get("MAIL_SERVER")
app.config["MAIL_PORT"] = int(os.environ.get("MAIL_PORT"))
app.config["MAIL_USERNAME"] = os.environ.get("MAIL_USERNAME")
app.config["MAIL_PASSWORD"] = os.environ.get("MAIL_PASSWORD")
app.config["MAIL_USE_TLS"] = True
app.config["MAIL_USE_SSL"] = False
app.config["MAIL_DEFAULT_SENDER"] = os.environ.get("MAIL_USERNAME")
mail = Mail(app)

def get_db_connection():
    return mysql.connector.connect(
        host=os.environ.get("DB_HOST"),
        user=os.environ.get("DB_USER"),
        password=os.environ.get("DB_PASSWORD"),
        database=os.environ.get("DB_NAME")
    )

@app.route("/")
def dashboard():
    if 'admin' not in session:
        return redirect(url_for("login"))
    recherche = request.args.get("recherche", "")
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    if recherche:
        filtre = f"%{recherche}%"
        cursor.execute("SELECT * FROM users WHERE nom LIKE %s OR prenom LIKE %s OR email LIKE %s", (filtre, filtre, filtre))
    else:
        cursor.execute("SELECT * FROM users")
    users = cursor.fetchall()
    conn.close()
    return render_template("dashboard.html", users=users)

@app.route("/delete_user/<email>", methods=["POST"])
def delete_user(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("DELETE FROM cagnotte_logs WHERE user_email = %s", (email,))
    cursor.execute("DELETE FROM users WHERE email = %s", (email,))
    conn.commit()
    conn.close()
    flash("Utilisateur supprimé.")
    return redirect(url_for("dashboard"))

@app.route("/login", methods=["GET", "POST"])
def login():
    if request.method == "POST":
        email = request.form["email"]
        password = request.form["password"]
        conn = get_db_connection()
        cursor = conn.cursor(dictionary=True)
        cursor.execute("SELECT * FROM admins WHERE email = %s AND mot_de_passe = %s", (email, password))
        admin = cursor.fetchone()
        conn.close()
        if admin:
            session["admin"] = True
            return redirect(url_for("dashboard"))
        flash("Identifiants invalides.")
    return render_template("login.html")

@app.route("/profile/<email>")
def voir_utilisateur(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    conn.close()
    if user:
        return render_template("profile.html", user=user)
    else:
        return "Utilisateur introuvable."

    email = request.form.get("email")
    ajout = request.form.get("ajout")
    retrait = request.form.get("retrait")
    remplacement = request.form.get("remplacement")
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if ajout:
        cagnotte += int(ajout)
    if retrait:
        cagnotte -= int(retrait)
    if remplacement:
        cagnotte = int(remplacement)
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/modifier_cagnotte", methods=["POST"])
def modifier_cagnotte():
    if 'admin' not in session:
        return redirect(url_for("login"))
    email = request.form.get("email")
    montant = request.form.get("montant")
    action = request.form.get("action")
    if not montant or not action:
        flash("Champ manquant.")
        return redirect(url_for("voir_utilisateur", email=email))
    montant = int(montant)
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if action == "ajouter":
        cagnotte += montant
    elif action == "retirer":
        cagnotte -= montant
    elif action == "remplacer":
        cagnotte = montant
    else:
        flash("Action invalide.")
        return redirect(url_for("voir_utilisateur", email=email))
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

    email = request.form.get("email")
    montant = request.form.get("montant")
    action = request.form.get("action")
    if not email or not montant or not action:
        flash("Champs manquants.")
        return redirect(url_for("dashboard"))
    try:
        montant = int(montant)
    except ValueError:
        flash("Montant invalide.")
        return redirect(url_for("dashboard"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT cagnotte FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    if not user:
        conn.close()
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    cagnotte = user['cagnotte']
    if action == "ajouter":
        cagnotte += montant
    elif action == "retirer":
        cagnotte -= montant
    elif action == "remplacer":
        cagnotte = montant
    else:
        conn.close()
        flash("Action invalide.")
        return redirect(url_for("dashboard"))
    cursor.execute("UPDATE users SET cagnotte = %s WHERE email = %s", (cagnotte, email))
    cursor.execute("INSERT INTO cagnotte_logs (user_email, montant) VALUES (%s, %s)", (email, cagnotte))
    conn.commit()
    conn.close()
    flash("Cagnotte mise à jour.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/create_user", methods=["GET", "POST"])
def create_user():
    if 'admin' not in session:
        return redirect(url_for("login"))
    if request.method == "POST":
        nom = request.form["nom"]
        prenom = request.form["prenom"]
        email = request.form["email"]
        telephone = request.form["telephone"]
        adresse = request.form["adresse"]
        token = os.urandom(16).hex()
        conn = get_db_connection()
        cursor = conn.cursor()
        cursor.execute("INSERT INTO users (nom, prenom, email, tel, adrs, token, cagnotte) VALUES (%s, %s, %s, %s, %s, %s, %s)", (nom, prenom, email, telephone, adresse, token, 0))
        conn.commit()
        conn.close()
        # Générer le QR Code
        qr = qrcode.make(token)
        qr_path = os.path.join("qr_temp", f"{email.replace('@', '_')}.png")
        qr.save(qr_path)
        msg = Message("Bienvenue dans notre programme de fidélité", recipients=[email])
        msg.body = f"Bonjour {prenom},\n\nVoici votre QR code en pièce jointe.\n\nCordialement."
        with open(qr_path, 'rb') as fp:
            msg.attach("qrcode.png", "image/png", fp.read())
        mail.send(msg)
        flash("Utilisateur créé et e-mail envoyé !")
        return redirect(url_for("dashboard"))
    return render_template("create_user.html")

@app.route("/scanner")
def scanner():
    if 'admin' not in session:
        return redirect(url_for("login"))
    return render_template("scanner.html")

@app.route("/renvoyer_qr/<email>", methods=["POST"])
def renvoyer_qr(email):
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT prenom, token FROM users WHERE email = %s", (email,))
    user = cursor.fetchone()
    conn.close()
    if not user:
        flash("Utilisateur introuvable.")
        return redirect(url_for("dashboard"))
    qr = qrcode.make(token)
    qr_path = os.path.join("qr_temp", f"{email.replace('@', '_')}.png")
    qr.save(qr_path)
    msg = Message("Rappel : votre QR Code", recipients=[email])
    msg.body = f"Bonjour {user['prenom']},\n\nVoici à nouveau votre QR code en pièce jointe.\n\nCordialement."
    with open(qr_path, 'rb') as fp:
        msg.attach("qrcode.png", "image/png", fp.read())
    mail.send(msg)
    flash("QR code renvoyé à l’utilisateur.")
    return redirect(url_for("voir_utilisateur", email=email))

@app.route("/historique")
def historique():
    if 'admin' not in session:
        return redirect(url_for("login"))
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("""SELECT c.*, u.nom, u.prenom FROM cagnotte_logs c JOIN users u ON u.email = c.user_email ORDER BY c.date_ajout DESC""")
    logs = cursor.fetchall()
    for log in logs:
        if isinstance(log['date_ajout'], datetime):
            log['date_ajout'] = log['date_ajout'].strftime('%d/%m/%Y %H:%M:%S')
    for log in logs:
        if isinstance(log['date_ajout'], datetime):
            log['date_ajout'] = log['date_ajout'].strftime('%d/%m/%Y %H:%M:%S')
    conn.close()
    return render_template("historique.html", logs=logs)


@app.route("/envoyer-email-masse", methods=["GET", "POST"])
def envoyer_email_masse():
    if "admin" not in session:
        return redirect("/login")

    if request.method == "POST":
        sujet = request.form["sujet"]
        message = request.form["message"]

        conn = get_db_connection()
        cursor = conn.cursor(dictionary=True)
        cursor.execute("SELECT email, prenom FROM users")
        users = cursor.fetchall()
        conn.close()

        for user in users:
            msg = Message(sujet, recipients=[user["email"]])
            msg.body = f"Bonjour {user['prenom']},\n\n{message}\n\nCordialement."
            mail.send(msg)

        flash("E-mails envoyés avec succès à tous les utilisateurs.")
        return "✅ E-mails envoyés à tous les utilisateurs avec succès !"

    return render_template("email_masse.html")

@app.route("/scan/<token>")
def scan_token(token):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM users WHERE token = %s", (token,))
    user = cursor.fetchone()
    conn.close()
    if not user:
        return render_template("code_introuvable.html")
    return redirect(url_for("voir_utilisateur", email=user["email"]))

@app.route("/logout")
def logout():
    session.clear()
    return redirect(url_for("login"))

@app.context_processor
def inject_version():
    return {'version': '0.2 Rayan B.'}
    
@app.errorhandler(404)
def page_not_found(e):
    return render_template("404.html"), 404
    
@app.route('/check-update')
def check_update():
    try:
        response = requests.get(REMOTE_VERSION_URL, timeout=5)
        latest_version = response.text.strip()

        if latest_version > LOCAL_VERSION:
            flash(f"Mise à jour disponible ! Version actuelle : {LOCAL_VERSION}, nouvelle : {latest_version}", "info")
        else:
            flash(f"Votre application est à jour (version {LOCAL_VERSION})", "success")
    except Exception as e:
        flash(f"Erreur de connexion au serveur de mise à jour : {e}", "danger")

    return redirect(url_for("dashboard"))  # ou autre page principale
    
@app.route("/update-now")
def update_now():
    try:
        subprocess.Popen(["python", "updater.py"])
        flash("Mise à jour lancée. L'application va redémarrer.", "info")
    except Exception as e:
        flash(f"Erreur lors du lancement de la mise à jour : {e}", "danger")
    return redirect(url_for("dashboard"))


if __name__ == "__main__":
    app.run(host="0.0.0.0", port=8443, ssl_context=("cert.pem", "key.pem"))
